/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rbf;

import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.persist.Persistable;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.rbf.RbfException;
import com.ibm.hwmca.fw.rbf.RbfRequestId;
import com.ibm.hwmca.fw.rbf.RbfRequestType;
import com.ibm.hwmca.fw.rbf.impl.RbfUtils;
import com.ibm.hwmca.fw.rbf.impl.RequestHandlingManager;
import com.ibm.hwmca.fw.rbf.impl.RequestManager;
import com.ibm.hwmca.fw.rbf.impl.RequestTrackingData;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class RbfRequest
implements Persistable {
    private static final String TRACE_MASKT = "XRBFREQT";
    private static final String TRACE_MASKF = "XRBFREQF";
    private static final String TRACE_MASKD = "XRBFREQD";
    private RbfRequestId identifier = null;
    private RbfRequestType type = null;
    private LocalizableText shortDescription = null;
    private String resultProcessor = null;
    private Object body = null;
    private boolean persist = true;
    private int scope = 1;
    private RequestTrackingData trackingData = new RequestTrackingData();
    private static final Class RBF_RESULT_PROCESSOR_CLASS = class$com$ibm$hwmca$fw$rbf$RbfResultProcessor == null ? (class$com$ibm$hwmca$fw$rbf$RbfResultProcessor = RbfRequest.class$("com.ibm.hwmca.fw.rbf.RbfResultProcessor")) : class$com$ibm$hwmca$fw$rbf$RbfResultProcessor;
    public static final int SCOPE_LOCAL_ONLY = 0;
    public static final int SCOPE_ANY_AVAILABLE = 1;
    public static final int SCOPE_SUBSET = 2;
    public static final int SCOPE_PREFERRED = 3;
    public static final int STATE_NEW = 0;
    public static final int STATE_SUBMITTED = 4;
    public static final int STATE_ABORTING = 6;
    public static final int STATE_HANDLING = 8;
    public static final int STATE_CANCELING = 12;
    public static final int STATE_REPORT_PENDING = 16;
    public static final int STATE_COMPLETE = 20;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$rbf$RbfResultProcessor;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$persist$Persistable;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$persist$PersistentData;

    public RbfRequest(RbfRequestType type, LocalizableText shortDesc, String resultProcClassName, Object body) {
        this(type, shortDesc, resultProcClassName, body, true, 1);
    }

    public RbfRequest(RbfRequestType type, LocalizableText shortDesc, String resultProcClassName, Object body, boolean persist, int scope) {
        if (type == null) {
            throw new IllegalArgumentException("Null request type");
        }
        if (resultProcClassName == null) {
            throw new IllegalArgumentException("Null result processor class name");
        }
        if (!this.isScopeValid(scope)) {
            throw new IllegalArgumentException("Invalid scope");
        }
        if (!(body == null || (class$java$io$Serializable == null ? (class$java$io$Serializable = RbfRequest.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(body.getClass()) || (class$com$ibm$hwmca$fw$persist$Persistable == null ? (class$com$ibm$hwmca$fw$persist$Persistable = RbfRequest.class$("com.ibm.hwmca.fw.persist.Persistable")) : class$com$ibm$hwmca$fw$persist$Persistable).isAssignableFrom(body.getClass()) || (class$com$ibm$hwmca$fw$persist$PersistentData == null ? (class$com$ibm$hwmca$fw$persist$PersistentData = RbfRequest.class$("com.ibm.hwmca.fw.persist.PersistentData")) : class$com$ibm$hwmca$fw$persist$PersistentData).isAssignableFrom(body.getClass()))) {
            String msg = "The body does not implement either java.io.Serializable, com.ibm.hwmca.fw.persist.Persistable, or com.ibm.hwmca.fw.persist.PersistentData";
            throw new IllegalArgumentException(msg);
        }
        try {
            Class<?> procClass = Class.forName(resultProcClassName);
            if (!RBF_RESULT_PROCESSOR_CLASS.isAssignableFrom(procClass)) {
                String msg = "The result processor class does not implement " + RBF_RESULT_PROCESSOR_CLASS.getName();
                throw new IllegalArgumentException(msg);
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("ClassNotFoundException: " + e.getMessage());
        }
        if (shortDesc == null) {
            shortDesc = new LocalizableText("Undescribed RBF request");
        }
        this.type = type;
        this.shortDescription = shortDesc;
        this.resultProcessor = resultProcClassName;
        this.body = body;
        this.persist = persist;
        this.scope = scope;
        this.identifier = new RbfRequestId();
        Trace.trace(TRACE_MASKT, "<> RbfRequest() " + this.identifier.toString());
    }

    public RbfRequest(RbfRequestType type, LocalizableText shortDesc, String resultProcClassName, Object body, boolean persist, Set handlerSubset) {
        this(type, shortDesc, resultProcClassName, body, persist, 2, handlerSubset);
    }

    public RbfRequest(RbfRequestType type, LocalizableText shortDesc, String resultProcClassName, Object body, boolean persist, int scope, Set handlerSubset) {
        if (type == null) {
            throw new IllegalArgumentException("Null request type");
        }
        if (resultProcClassName == null) {
            throw new IllegalArgumentException("Null result processor class name");
        }
        if (scope != 2 && scope != 3) {
            throw new IllegalArgumentException("Invalid scope for handler subset");
        }
        if (handlerSubset == null || handlerSubset.isEmpty()) {
            throw new IllegalArgumentException("Null or empty handler subset");
        }
        if (!(body == null || (class$java$io$Serializable == null ? (class$java$io$Serializable = RbfRequest.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(body.getClass()) || (class$com$ibm$hwmca$fw$persist$Persistable == null ? (class$com$ibm$hwmca$fw$persist$Persistable = RbfRequest.class$("com.ibm.hwmca.fw.persist.Persistable")) : class$com$ibm$hwmca$fw$persist$Persistable).isAssignableFrom(body.getClass()) || (class$com$ibm$hwmca$fw$persist$PersistentData == null ? (class$com$ibm$hwmca$fw$persist$PersistentData = RbfRequest.class$("com.ibm.hwmca.fw.persist.PersistentData")) : class$com$ibm$hwmca$fw$persist$PersistentData).isAssignableFrom(body.getClass()))) {
            String msg = "The body does not implement either java.io.Serializable, com.ibm.hwmca.fw.persist.Persistable, or com.ibm.hwmca.fw.persist.PersistentData";
            throw new IllegalArgumentException(msg);
        }
        try {
            Class<?> procClass = Class.forName(resultProcClassName);
            if (!RBF_RESULT_PROCESSOR_CLASS.isAssignableFrom(procClass)) {
                String msg = "The result processor class does not implement " + RBF_RESULT_PROCESSOR_CLASS.getName();
                throw new IllegalArgumentException(msg);
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("ClassNotFoundException: " + e.getMessage());
        }
        Iterator iterator = handlerSubset.iterator();
        while (iterator.hasNext()) {
            Object element = iterator.next();
            if (element == null) {
                throw new IllegalArgumentException("Null element in handler subset");
            }
            if (element instanceof MachineId) continue;
            throw new IllegalArgumentException("Non-MachineId element in handler subset");
        }
        if (shortDesc == null) {
            shortDesc = new LocalizableText("Undescribed RBF request");
        }
        this.type = type;
        this.shortDescription = shortDesc;
        this.resultProcessor = resultProcClassName;
        this.body = body;
        this.persist = persist;
        this.scope = scope;
        this.trackingData.setHandlerSubset(new HashSet(handlerSubset));
        this.identifier = new RbfRequestId();
        Trace.trace(TRACE_MASKT, "<> RbfRequest() " + this.identifier.toString());
    }

    protected RbfRequest(PersistentData data) throws PersistenceException {
        Persistent persistent = (Persistent)data;
        int rbfVersion = persistent.rbfVersion;
        this.identifier = persistent.identifier;
        this.type = persistent.type;
        this.shortDescription = persistent.shortDescription;
        this.resultProcessor = persistent.resultProcessor;
        this.body = null;
        this.persist = persistent.persist;
        this.scope = persistent.scope;
        this.trackingData = new RequestTrackingData(persistent.trackingData);
    }

    public PersistentData getPersistentData() {
        Persistent persistent = new Persistent();
        persistent.rbfVersion = 2;
        persistent.identifier = this.identifier;
        persistent.type = this.type;
        persistent.shortDescription = this.shortDescription;
        persistent.resultProcessor = this.resultProcessor;
        persistent.persist = this.persist;
        persistent.scope = this.scope;
        persistent.trackingData = this.trackingData.getPersistentData();
        return persistent;
    }

    public boolean isUpgradeData() {
        return false;
    }

    public static RbfRequest getRequest(RbfRequestId identifier) {
        try {
            RequestManager requestMgr = RequestManager.getRequestManager();
            return requestMgr.getRequest(identifier);
        }
        catch (RbfException rbfe) {
            return null;
        }
    }

    public final RbfRequestId getIdentifier() {
        return this.identifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setType(RbfRequestType type) {
        Trace.trace(TRACE_MASKT, "-> setType() " + this.identifier);
        RequestTrackingData requestTrackingData = this.trackingData;
        synchronized (requestTrackingData) {
            if (type == null) {
                throw new IllegalArgumentException("Null request type");
            }
            if (this.trackingData.getState() != 0) {
                throw new IllegalStateException("Request already submitted");
            }
            this.type = type;
        }
        Trace.trace(TRACE_MASKT, "<- setType()");
    }

    public final RbfRequestType getType() {
        return this.type;
    }

    public final LocalizableText getShortDescription() {
        return this.shortDescription;
    }

    public final String getResultProcessor() {
        return this.resultProcessor;
    }

    public final void setBody(Object body) {
        this.body = body;
    }

    public final Object getBody() {
        return this.body;
    }

    public final boolean isPersistent() {
        return this.persist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setScope(int scope) {
        Trace.trace(TRACE_MASKT, "-> setScope(" + scope + ") " + this.identifier);
        RequestTrackingData requestTrackingData = this.trackingData;
        synchronized (requestTrackingData) {
            if (!this.isScopeValid(scope)) {
                throw new IllegalArgumentException("Invalid scope");
            }
            if (this.trackingData.getState() != 0) {
                throw new IllegalStateException("Request already submitted");
            }
            this.scope = scope;
        }
        Trace.trace(TRACE_MASKT, "<- setScope()");
    }

    public final int getScope() {
        return this.scope;
    }

    private boolean isScopeValid(int scope) {
        switch (scope) {
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
            case 3: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setHandlerSubset(Set handlerSubset) {
        Trace.trace(TRACE_MASKT, "-> setHandlerSubset() " + this.identifier);
        RequestTrackingData requestTrackingData = this.trackingData;
        synchronized (requestTrackingData) {
            if (this.trackingData.getState() != 0) {
                throw new IllegalStateException("Request already submitted");
            }
            if (handlerSubset == null || handlerSubset.isEmpty()) {
                throw new IllegalArgumentException("Null or empty handler subset");
            }
            Iterator iterator = handlerSubset.iterator();
            while (iterator.hasNext()) {
                Object element = iterator.next();
                if (element == null) {
                    throw new IllegalArgumentException("Null element in handler subset");
                }
                if (element instanceof MachineId) continue;
                throw new IllegalArgumentException("Non-MachineId element in handler subset");
            }
            this.trackingData.setHandlerSubset(new HashSet(handlerSubset));
        }
        Trace.trace(TRACE_MASKT, "<- setHandlerSubset()");
    }

    public final Set getHandlerSubset() {
        return this.trackingData.getHandlerSubset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void submit() throws IllegalStateException, RbfException {
        Trace.trace(TRACE_MASKT, "-> submit()");
        RequestTrackingData requestTrackingData = this.trackingData;
        synchronized (requestTrackingData) {
            if (this.trackingData.getState() != 0) {
                throw new IllegalStateException("Request already submitted");
            }
            RequestManager.getRequestManager().submit(this);
        }
        Trace.trace(TRACE_MASKT, "<- submit()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cancel() throws IllegalStateException {
        Trace.trace(TRACE_MASKT, "-> cancel()");
        RequestTrackingData requestTrackingData = this.trackingData;
        synchronized (requestTrackingData) {
            if (this.trackingData.getState() == 0) {
                throw new IllegalStateException("Request not submitted");
            }
            if (this.trackingData.isHandlerCopy()) {
                try {
                    RequestHandlingManager.getRequestHandlingManager().cancel(this);
                }
                catch (RbfException rbfe) {}
            } else {
                try {
                    RequestManager.getRequestManager().cancel(this);
                }
                catch (RbfException rbfException) {
                    // empty catch block
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- cancel()");
    }

    public boolean shouldBeHandled() {
        return true;
    }

    public final RequestTrackingData getTrackingData() {
        return this.trackingData;
    }

    public final int getState() {
        return this.trackingData.getState();
    }

    public final Date getSubmitDate() {
        return this.trackingData.getSubmitDate();
    }

    public final MachineId getOriginMachine() {
        return this.trackingData.getOrigin();
    }

    public final MachineId getHandlingMachine() {
        return this.trackingData.getHandler();
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof RbfRequest)) {
            return false;
        }
        RbfRequest request = (RbfRequest)obj;
        return this.identifier.equals(request.identifier);
    }

    public final int hashCode() {
        return this.identifier.hashCode();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[RbfRequest:\n");
        sb.append("class=" + this.getClass().getName() + "\n");
        sb.append("id=" + this.identifier + "\n");
        sb.append("type=" + this.type + "\n");
        sb.append("desc=" + this.shortDescription + "\n");
        sb.append("resultProc=" + this.resultProcessor + "\n");
        if (this.body == null) {
            sb.append("body=null\n");
        } else {
            sb.append("body=" + this.body.getClass().getName() + "\n");
        }
        sb.append("persist=" + this.persist + "\n");
        sb.append("scope=" + this.scope + "\n");
        sb.append("handlerSubset=" + RbfUtils.getMachineInfo(this.trackingData.getHandlerSubset()) + "\n");
        sb.append("state=" + this.trackingData.getState() + "\n");
        sb.append("submitDate=" + this.trackingData.getSubmitDate() + "\n");
        MachineId origin = this.trackingData.getOrigin();
        if (origin != null) {
            sb.append("origin=" + RbfUtils.getMachineInfo(origin) + "\n");
        } else {
            sb.append("origin=null\n");
        }
        MachineId handling = this.trackingData.getHandler();
        if (handling != null) {
            sb.append("handling=" + RbfUtils.getMachineInfo(origin));
        } else {
            sb.append("handling=null");
        }
        sb.append("]");
        return sb.toString();
    }

    public final String toDebugString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[RbfRequest:\n");
        sb.append("class=" + this.getClass().getName() + "\n");
        sb.append("id=" + this.identifier + "\n");
        sb.append("type=" + this.type + "\n");
        sb.append("desc=" + this.shortDescription + "\n");
        sb.append("resultProc=" + this.resultProcessor + "\n");
        if (this.body == null) {
            sb.append("body=null\n");
        } else {
            sb.append("body=" + this.body.getClass().getName() + "\n");
        }
        sb.append("persist=" + this.persist + "\n");
        sb.append("scope=" + this.scope + "\n");
        sb.append("tracking=" + this.trackingData);
        sb.append("]");
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Persistent
    implements PersistentData {
        private static final long serialVersionUID = -8498693642525595313L;
        int rbfVersion;
        RbfRequestId identifier;
        RbfRequestType type;
        LocalizableText shortDescription;
        String resultProcessor;
        boolean persist;
        int scope;
        PersistentData trackingData;

        private Persistent() {
        }
    }
}

